/*
 * @(#)OMAttribute.java  1.0  6. Februar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.objectmodel;

import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;
/**
 * Represents an attribute defined by a {@link OMClass}.
 * <p>
 * Important: equals and hashCode must be based on identity and not on the
 * attributes of this object.
 * 
 * 
 * 
 * @author Werner Randelshofer
 * @version 1.0 6. Februar 2004  Created.
 */
public class OMAttribute implements Cloneable, DOMStorable {
    private String name;
    private OMClass clazz;
    
    /** Creates a new instance. */
    public OMAttribute(OMClass clazz, String name) {
        this.clazz = clazz;
        this.name = name;
    }
    
    /**
     * This constructor is required for DOMStorable functionality.
     * Do <b>not</b> not use it for anything else.
     */
    public OMAttribute() {
    }
    
    public OMClass getDefiningClass() {
        return clazz;
    }
    public void setDeclaringClass(OMClass clazz) {
        this.clazz = clazz;
    }
    private ObjectModel getObjectModel() {
        return clazz.getObjectModel();
    }
    
    public void setName(String name) {
        this.name = name;
    }
    public String getName() {
        return name;
    }
    public String getAttributeName() {
        int p = name.indexOf('=');
        return (p == -1) ? name : name.substring(0, p);
    }
    public Object getInitialValue() {
        int p = name.indexOf('=');
        return (p == -1) ? null : getObjectModel().unwrapValue(name.substring(p+1));
    }
    
    public Object clone() {
        try {
            OMAttribute that = (OMAttribute) super.clone();
            return that;
        } catch (CloneNotSupportedException e) {
            InternalError error = new InternalError(e.toString());
            //error.initCause(e); <- requires JDK 1.4
            throw error;
        }
    }
    
    public void read(DOMInput in) {
        name = in.getAttribute("name", "attribut");
    }
    
    public void write(DOMOutput out) {
        out.addAttribute("name", name);
    }
    
    public String toString() {
        return "objectmodel.Attribute "+getAttributeName()+" definingClass:"+getDefiningClass().getName();
    }
}
